<?php
require_once __DIR__ . '/../init.php';

// Check if user is logged in and is admin
if (!isset($_SESSION['user']) || $_SESSION['user']['role'] !== 'admin') {
    header('Location: /barcode-system/admin/login.php');
    exit;
}

$user_id = $_SESSION['user']['id'];
$message = '';
$message_type = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $current_password = $_POST['current_password'] ?? '';
    $new_password = $_POST['new_password'] ?? '';
    $confirm_password = $_POST['confirm_password'] ?? '';

    if (empty($current_password) || empty($new_password) || empty($confirm_password)) {
        $message = 'الرجاء إدخال جميع الحقول.';
        $message_type = 'danger';
    } elseif ($new_password !== $confirm_password) {
        $message = 'كلمتا المرور الجديدتان غير متطابقتين.';
        $message_type = 'danger';
    } elseif (strlen($new_password) < 6) {
        $message = 'يجب أن لا تقل كلمة المرور الجديدة عن 6 أحرف.';
        $message_type = 'danger';
    } else {
        // Verify current password
        $stmt = $pdo->prepare('SELECT password_hash FROM users WHERE id = ?');
        $stmt->execute([$user_id]);
        $user = $stmt->fetch();

        if ($user && password_verify($current_password, $user['password_hash'])) {
            // Update password
            $new_password_hash = password_hash($new_password, PASSWORD_DEFAULT);
            $update_stmt = $pdo->prepare('UPDATE users SET password_hash = ? WHERE id = ?');
            $update_stmt->execute([$new_password_hash, $user_id]);

            $message = 'تم تغيير كلمة المرور بنجاح! سيتم تسجيل خروجك.';
            $message_type = 'success';
            
            // Log user out after successful change for security
            session_destroy();
            header('Refresh: 3; URL=/barcode-system/admin/login.php'); // Redirect after 3 seconds
        } else {
            $message = 'كلمة المرور الحالية غير صحيحة.';
            $message_type = 'danger';
        }
    }
}
?>
<!doctype html>
<html lang="ar">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title>تغيير كلمة المرور - Backcare</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body{font-family:Tajawal,sans-serif;background:#f6f8fa;padding:16px;direction:rtl;}
        .card{border-radius:12px;padding:16px;margin-bottom:16px;box-shadow:0 4px 12px rgba(0,0,0,0.05);}
    </style>
</head>
<body>
    <div class="container">
        <div class="card" style="max-width: 500px; margin: 30px auto;">
            <h4>تغيير كلمة المرور للمستخدم: <?= htmlspecialchars($_SESSION['user']['username']) ?></h4>

            <?php if ($message): ?>
                <div class="alert alert-<?= $message_type ?>"><?= $message ?></div>
            <?php endif; ?>
            
            <?php if($message_type !== 'success'): ?>
            <form method="post">
                <div class="mb-3">
                    <label class="form-label">كلمة المرور الحالية</label>
                    <input type="password" name="current_password" class="form-control" required>
                </div>
                <div class="mb-3">
                    <label class="form-label">كلمة المرور الجديدة</label>
                    <input type="password" name="new_password" class="form-control" required minlength="6">
                </div>
                <div class="mb-3">
                    <label class="form-label">تأكيد كلمة المرور الجديدة</label>
                    <input type="password" name="confirm_password" class="form-control" required>
                </div>
                <button type="submit" class="btn btn-primary">تغيير كلمة المرور</button>
                <a href="/barcode-system/admin/index.php" class="btn btn-secondary">إلغاء</a>
            </form>
            <?php endif; ?>
        </div>
    </div>
</body>
</html>