<?php

// تحديد اسم الملف المراد إنشاؤه
$filename = '100000_barcodes.csv';
// عدد الباركودات المطلوبة
$count = 100000;
// البادئة المطلوبة للباركود
$prefix = 'BC';

// فتح الملف للكتابة (وضع 'w' سيمحو أي محتوى سابق)
$file = fopen($filename, 'w');

if (!$file) {
    die("خطأ: لا يمكن فتح الملف للكتابة.");
}

// كتابة سطر العناوين في ملف CSV (نحن نحتاج عمود الباركود فقط)
fputcsv($file, ['barcode', 'name', 'size', 'production_date', 'expiry_date', 'notes']);

// حلقة لإنشاء 100,000 باركود
for ($i = 1; $i <= $count; $i++) {
    // تنسيق الرقم ليكون طوله ثابتاً (7 أرقام مثلاً: 0000001)
    $number = str_pad($i, 7, '0', STR_PAD_LEFT);
    
    $barcode = $prefix . $number;
    
    // صف البيانات: نضع الباركود في العمود الأول، وبقية الأعمدة فارغة
    // يمكنك تعديل هذا الصف إذا كنت تريد ملء بيانات اسم المنتج بشكل تسلسلي أيضاً
    $row = [
        $barcode, 
        'Product Name ' . $i, // اسم منتج تسلسلي
        'Size-L', 
        null, 
        null, 
        null
    ];
    
    // كتابة الصف في ملف CSV
    fputcsv($file, $row);
}

// إغلاق الملف
fclose($file);

echo "✅ تم إنشاء ملف $filename بنجاح! يحتوي على $count باركود تبدأ بـ '$prefix'.";

?>