<?php
// auth.php (معالج تسجيل الدخول والخروج)
require_once __DIR__ . '/init.php';

if($_SERVER['REQUEST_METHOD'] === 'POST'){
  $u = $_POST['username'] ?? '';
  $p = $_POST['password'] ?? '';
  
  // البحث عن المستخدم
  $stmt = $pdo->prepare('SELECT id,username,password_hash,role FROM users WHERE username = ? LIMIT 1');
  $stmt->execute([$u]);
  $user = $stmt->fetch();
  
  // التحقق من كلمة المرور
  if($user && password_verify($p, $user['password_hash'])){
    // تسجيل الدخول بنجاح
    unset($user['password_hash']);
    $_SESSION['user'] = $user;
    
    // التوجيه إلى لوحة الإدارة
    header('Location: ' . '/barcode-system/admin/index.php');
    exit;
  }
  
  // فشل تسجيل الدخول: حفظ الخطأ وإعادة التوجيه لصفحة الدخول
  $_SESSION['login_error'] = 'بيانات الدخول غير صحيحة';
  header('Location: ' . '/barcode-system/admin/login.php');
  exit;
}

if(isset($_GET['action']) && $_GET['action']==='logout'){
  // تسجيل الخروج
  session_destroy();
  
  // التوجيه إلى صفحة تسجيل الدخول
  header('Location: ' . '/barcode-system/admin/login.php');
  exit;
}