<?php
require_once __DIR__ . '/../init.php';

// 🛑 التحقق من صلاحيات المدير العام فقط (Super Admin)
if (!isset($_SESSION['user']) || $_SESSION['user']['role'] !== 'super_admin') {
    header('Location: /barcode-system/admin/index.php');
    exit;
}

$current_user_id = $_SESSION['user']['id'];
$message = '';
$message_type = '';

// 🔍 معالجة طلب الحذف
if (isset($_GET['action']) && $_GET['action'] === 'delete' && isset($_GET['id'])) {
    $delete_id = (int)$_GET['id'];
    
    // منع حذف المدير العام نفسه!
    if ($delete_id === $current_user_id) {
        $message = 'لا يمكنك حذف حسابك الحالي.';
        $message_type = 'danger';
    } else {
        try {
            $stmt = $pdo->prepare('DELETE FROM users WHERE id = ?');
            $stmt->execute([$delete_id]);
            
            if ($stmt->rowCount()) {
                $message = 'تم حذف المستخدم بنجاح.';
                $message_type = 'success';
                // إعادة التوجيه لمنع إعادة الإرسال
                header("Location: " . $_SERVER['PHP_SELF'] . "?msg=" . urlencode($message) . "&type=success");
                exit;
            } else {
                $message = 'فشل حذف المستخدم أو لم يتم العثور عليه.';
                $message_type = 'warning';
            }
        } catch (\PDOException $e) {
            $message = 'خطأ في قاعدة البيانات: ' . $e->getMessage();
            $message_type = 'danger';
        }
    }
}

// عرض رسائل بعد إعادة التوجيه
if (isset($_GET['msg']) && isset($_GET['type'])) {
    $message = htmlspecialchars($_GET['msg']);
    $message_type = htmlspecialchars($_GET['type']);
}

// 🗂️ جلب جميع المستخدمين باستثناء المستخدم الحالي
$users = $pdo->prepare('SELECT id, username, role, created_at FROM users WHERE id != ? ORDER BY id DESC');
$users->execute([$current_user_id]);
$user_list = $users->fetchAll(PDO::FETCH_ASSOC);
?>
<!doctype html>
<html lang="ar">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title>إدارة المستخدمين</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body{font-family:Tajawal,sans-serif;background:#f6f8fa;padding:16px;direction:rtl;}
        .card{border-radius:12px;padding:16px;margin-bottom:16px;box-shadow:0 4px 12px rgba(0,0,0,0.05);}
    </style>
</head>
<body>
    <div class="container">
        <h4 class="mb-4">إدارة المستخدمين</h4>

        <?php if ($message): ?>
            <div class="alert alert-<?= $message_type ?>"><?= $message ?></div>
        <?php endif; ?>

        <div class="mb-3 d-flex justify-content-between">
            <a href="add_user.php" class="btn btn-primary">➕ إضافة مستخدم جديد</a>
            <a href="/barcode-system/admin/index.php" class="btn btn-secondary">العودة للوحة الإدارة</a>
        </div>

        <div class="card">
            <h5>قائمة المستخدمين (لا تشمل حسابك)</h5>
            <div class="table-responsive">
                <table class="table table-striped table-hover table-sm">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>اسم المستخدم</th>
                            <th>الصلاحية</th>
                            <th>تاريخ الإنشاء</th>
                            <th>إجراءات</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach($user_list as $u): ?>
                        <tr>
                            <td><?= $u['id'] ?></td>
                            <td><?= htmlspecialchars($u['username']) ?></td>
                            <td>
                                <?php 
                                // عرض الصلاحية بشكل واضح
                                switch($u['role']) {
                                    case 'super_admin': echo '<span class="badge text-bg-danger">مدير عام</span>'; break;
                                    case 'admin': echo '<span class="badge text-bg-warning">مدير مقيد</span>'; break;
                                    case 'user': echo '<span class="badge text-bg-info">مستخدم عادي</span>'; break;
                                    default: echo '-';
                                }
                                ?>
                            </td>
                            <td><?= date('Y-m-d', strtotime($u['created_at'])) ?></td>
                            <td>
                                <button onclick="deleteUser(<?= $u['id'] ?>,'<?= htmlspecialchars($u['username']) ?>')" class="btn btn-sm btn-danger">حذف</button>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    
    <script>
        function deleteUser(id, username) {
            if (confirm("هل أنت متأكد من حذف المستخدم '" + username + "'؟")) {
                window.location.href = `manage_users.php?action=delete&id=${id}`;
            }
        }
    </script>
</body>
</html>