<?php 
require_once __DIR__ . '/../init.php'; 

// التحقق مما إذا كان المستخدم مسجلاً دخوله بالفعل
if(isset($_SESSION['user']) && $_SESSION['user']['role']==='admin'){ 
    header('Location: ' . '/barcode-system/admin/index.php'); exit; 
} 

// التحقق من وجود خطأ تم تمريره من ملف auth.php
$error = $_SESSION['login_error'] ?? '';
unset($_SESSION['login_error']); // حذف الخطأ بعد عرضه لعدم تكراره

?>
<!doctype html>
<html lang="ar">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>تسجيل دخول - Backcare</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body{background: linear-gradient(135deg,#eaf2ff,#f7fbff);font-family:Tahoma,Arial,sans-serif}
    .card{border-radius:12px;box-shadow:0 6px 18px rgba(25,40,80,0.08)}
    .brand{font-weight:700;color:#0b5ed7}
  </style>
</head>
<body class="d-flex align-items-center justify-content-center" style="min-height:100vh">
  <div class="card p-4" style="width:420px">
    <div class="mb-3 text-center">
      <div class="brand" style="font-size:22px">Backcare</div>
      <div class="text-muted small">لوحة إدارة المنتجات والباركود</div>
    </div>
    <?php if(!empty($error)) echo "<div class='alert alert-danger'>{$error}</div>"; ?>
    <form method="post" action="/barcode-system/auth.php">
      <div class="mb-2"><label class="form-label">اسم المستخدم</label><input name="username" class="form-control" required></div>
      <div class="mb-3"><label class="form-label">كلمة المرور</label><input name="password" type="password" class="form-control" required></div>
      <button class="btn btn-primary w-100">دخول</button>
    </form>
  </div>
</body>
</html>