<?php
require_once __DIR__ . '/../init.php';

// 1. التحقق من صلاحيات الدخول: مسموح لـ super_admin و admin
if (!isset($_SESSION['user']) || ($_SESSION['user']['role'] !== 'super_admin' && $_SESSION['user']['role'] !== 'admin')) {
    header('Location: /barcode-system/admin/login.php');
    exit;
}

$rows = $pdo->query("SELECT * FROM products ORDER BY created_at DESC LIMIT 500")->fetchAll(PDO::FETCH_ASSOC);

// التعامل مع إضافة المنتج عبر POST
$error = $success = '';
if($_SERVER['REQUEST_METHOD']==='POST'){
    $barcode = trim($_POST['barcode'] ?? '');
    $name = trim($_POST['name'] ?? '');
    $size = trim($_POST['size'] ?? ''); // إضافة المقاس
    $production_date = $_POST['production_date'] ?: null;
    $expiry_date = $_POST['expiry_date'] ?: null;
    $notes = trim($_POST['notes'] ?? '');

    // التحقق: فقط Super Admin و Admin يمكنهم الإضافة
    if($_SESSION['user']['role'] !== 'super_admin' && $_SESSION['user']['role'] !== 'admin'){
        $error = "غير مصرح لك بإضافة منتجات.";
    } elseif(!$barcode || !$name){
        $error="الباركود واسم المنتج مطلوبان.";
    } else {
        // التأكد من عدم وجود الباركود مسبقاً
        $check = $pdo->prepare("SELECT id FROM products WHERE barcode=?");
        $check->execute([$barcode]);
        if($check->fetch()){
            $error="رمز الباركود مسجل مسبقاً.";
        } else {
            try {
                // إدراج المقاس في الاستعلام
                $stmt = $pdo->prepare("INSERT INTO products (barcode, name, size, production_date, expiry_date, notes, created_by) VALUES (?,?,?,?,?,?,?)");
                $stmt->execute([$barcode, $name, $size ?: null, $production_date, $expiry_date, $notes, $_SESSION['user']['id']]);
                $success = "تمت إضافة المنتج بنجاح. معرف: " . $pdo->lastInsertId();
                // إعادة توجيه لمنع إرسال النموذج مرة أخرى عند تحديث الصفحة
                header("Location: " . $_SERVER['PHP_SELF'] . "?success=" . urlencode($success));
                exit;
            } catch (Exception $e) {
                $error = "حدث خطأ أثناء الحفظ: " . $e->getMessage();
            }
        }
    }
}

// عرض رسائل النجاح أو الخطأ بعد إعادة التوجيه
if(isset($_GET['success'])){
    $success = htmlspecialchars($_GET['success']);
}
?>
<!doctype html>
<html lang="ar">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title>لوحة الإدارة - Backcare</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body{font-family:Tajawal,sans-serif;background:#f6f8fa;padding:16px;direction:rtl;}
        .card{border-radius:12px;padding:16px;margin-bottom:16px;box-shadow:0 4px 12px rgba(0,0,0,0.05);}
        .table-responsive{overflow-x:auto;}
    </style>
</head>
<body>
    <div class="container">
        
       <div class="mb-3">
    <h2 class="h4 mb-3">لوحة الإدارة</h2>
  <div class="d-grid gap-2 d-md-flex justify-content-md-start mb-3">
    <?php if ($_SESSION['user']['role'] === 'super_admin' || $_SESSION['user']['role'] === 'admin'): ?>
        <a href="/barcode-system/admin/generate_barcode_images.php" class="btn btn-info text-white">🖨️ طباعة المسجل</a>
    <?php endif; ?>

    <?php if ($_SESSION['user']['role'] === 'super_admin' || $_SESSION['user']['role'] === 'admin'): ?>
        <a href="/barcode-system/admin/generate_temporary_barcodes.php" class="btn btn-success">📄 طباعة (100K+)</a>
    <?php endif; ?>

    <?php if ($_SESSION['user']['role'] === 'super_admin'): ?>
        <a href="/barcode-system/admin/manage_users.php" class="btn btn-success">➕ إدارة المستخدمين</a>
    <?php endif; ?>
    <a href="/barcode-system/admin/export_csv.php" class="btn btn-secondary">📥 تصدير CSV</a>
    <a href="/barcode-system/admin/change_password.php" class="btn btn-warning">تغيير كلمة المرور</a>
    <a href="/barcode-system/auth.php?action=logout" class="btn btn-danger">تسجيل خروج</a>
</div>

        <?php if ($error): ?>
            <div class="alert alert-danger"><?= $error ?></div>
        <?php endif; ?>
        <?php if ($success): ?>
            <div class="alert alert-success"><?= $success ?></div>
        <?php endif; ?>
        
        <div class="card">
    <h4>إضافة منتج جديد</h4>
    <?php // السماح لـ Super Admin و Admin بإضافة المنتج ?>
    <?php if ($_SESSION['user']['role'] === 'super_admin' || $_SESSION['user']['role'] === 'admin'): ?>
    <form method="post" id="addProductForm">
        <div class="row">
    <div class="col-12 col-md-6 mb-2"> 
        <label class="form-label">باركود (مطلوب)</label>
        <input name="barcode" id="barcodeInput" class="form-control" required value="<?= htmlspecialchars($_POST['barcode'] ?? '') ?>">
        <button type="button" id="scanBtn" class="btn btn-sm btn-info mt-1">مسح بالكميرا</button>
        <video id="video" width="100%" height="auto" autoplay style="border-radius:8px; display:none; max-width: 320px;"></video>
    </div>
    </div>
            
            <div class="col-md-6 mb-2">
                <label class="form-label">اسم المنتج (مطلوب)</label>
                <input name="name" class="form-control" required value="<?= htmlspecialchars($_POST['name'] ?? '') ?>">
            </div>
            <div class="col-md-6 mb-2">
                <label class="form-label">المقاس (Size)</label>
                <input name="size" class="form-control" value="<?= htmlspecialchars($_POST['size'] ?? '') ?>">
            </div>
            <div class="col-md-6 mb-2">
                <label class="form-label">تاريخ الإنتاج</label>
                <input name="production_date" type="date" class="form-control" value="<?= htmlspecialchars($_POST['production_date'] ?? '') ?>">
            </div>
            <div class="col-md-6 mb-2">
                <label class="form-label">تاريخ الانتهاء</label>
                <input name="expiry_date" type="date" class="form-control" value="<?= htmlspecialchars($_POST['expiry_date'] ?? '') ?>">
            </div>
            <div class="col-md-6 mb-2">
                <label class="form-label">ملاحظات</label>
                <textarea name="notes" class="form-control"><?= htmlspecialchars($_POST['notes'] ?? '') ?></textarea>
            </div>
        </div>
        <button type="submit" class="btn btn-primary mt-2">حفظ المنتج</button>
    </form>
    <?php else: ?>
        <div class="alert alert-info">صلاحيتك تسمح بالعرض فقط، لا يمكنك إضافة منتجات.</div>
    <?php endif; ?>
</div>
        
<?php 
// تعريف الألوان الفاتحة للأعمدة
// تم تعديل الألوان لتكون أكثر حيادية لتقليل التشتيت مع الألوان الداكنة في العناوين
$col_colors = [
    'id' => '#f8f9fa',        // Light Gray
    'barcode' => '#e6f0ff',   // Very light Blue
    'name' => '#ffffff',      // White
    'size' => '#e6fffd',       // Very light Cyan
    'production_date' => '#fffbe6', // Very light Yellow
    'expiry_date' => '#ffebeb', // Very light Red
    'notes' => '#f5f5f5',     // Lighter Gray for notes
    'created_by' => '#e6f7ff',  // Very light Info/Cyan
    'created_at' => '#e6e6ff',   // Very light Blue/Purple
];
?>

<div class="card">
    <h4 class="mb-3">قائمة المنتجات (<span class="text-primary"><?= count($rows) ?></span>)</h4>
    <div class="table-responsive">
        <table class="table table-hover table-sm">
            
            <thead style="font-size: 0.9rem;">
                <tr style="border-bottom: 3px solid #ccc;">
                    <th scope="col" class="text-white text-center" style="width: 50px; background-color: #6c757d !important;">ID</th>
                    <th scope="col" class="text-white text-center" style="background-color: #0d6efd !important;">الباركود</th>
                    <th scope="col" class="text-white" style="background-color: #198754 !important;">الاسم</th>
                    <th scope="col" class="text-white text-center" style="width: 80px; background-color: #20c997 !important;">المقاس</th>
                    <th scope="col" class="text-center" style="background-color: #ffc107 !important; color: #333 !important;">تاريخ انتاج</th>
                    <th scope="col" class="text-white text-center" style="background-color: #dc3545 !important;">تاريخ انتهاء</th>
                    <th scope="col" class="text-white" style="background-color: #6f42c1 !important;">الملاحظات</th>
                    <th scope="col" class="text-center" style="background-color: #0dcaf0 !important; color: #333 !important;">بواسطة</th>
                    <th scope="col" class="text-white text-center" style="background-color: #000080 !important;">تاريخ الإنشاء</th>
                    <th scope="col" class="text-white text-center" style="width: 120px; background-color: #343a40 !important;">إجراءات</th>
                </tr>
            </thead>
            
            <tbody>
                <?php 
                $user_list = $pdo->query("SELECT id, username FROM users")->fetchAll(PDO::FETCH_KEY_PAIR);
                $today = new DateTime();
                
                foreach($rows as $r): 
                    $is_expired = false;
                    if ($r['expiry_date']) {
                        try {
                            $expiry_dt = new DateTime($r['expiry_date']);
                            if ($expiry_dt < $today) {
                                $is_expired = true;
                            }
                        } catch (Exception $e) {}
                    }
                    
                    $row_bg_color = $is_expired ? 'background-color: #ffdddd !important;' : '';
                ?>
                <tr style="<?= $row_bg_color ?>">
                    <td class="small text-center" style="background-color: <?= $col_colors['id'] ?> !important;"><?= $r['id'] ?></td>
                    <td class="small text-center text-break" style="background-color: <?= $col_colors['barcode'] ?> !important;"><strong><?= htmlspecialchars($r['barcode']) ?></strong></td>
                    <td class="small" style="background-color: <?= $col_colors['name'] ?> !important;"><?= htmlspecialchars($r['name']) ?></td>
                    <td class="small text-center" style="background-color: <?= $col_colors['size'] ?> !important;"><?= htmlspecialchars($r['size'] ?? '-') ?></td>
                    <td class="small text-center" style="background-color: <?= $col_colors['production_date'] ?> !important;"><?= htmlspecialchars($r['production_date'] ?? '-') ?></td>
                    <td class="small text-center <?= $is_expired ? 'fw-bold text-danger' : '' ?>" style="background-color: <?= $col_colors['expiry_date'] ?> !important;">
                        <?= htmlspecialchars($r['expiry_date'] ?? '-') ?>
                    </td>
                    
                    <td class="small" style="background-color: <?= $col_colors['notes'] ?> !important;">
                        <div class="text-truncate" style="max-width: 150px;" title="<?= htmlspecialchars($r['notes'] ?: 'لا توجد ملاحظات') ?>">
                            <?= htmlspecialchars($r['notes'] ?? '-') ?>
                        </div>
                    </td>
                    
                    <td class="small text-center text-muted" style="background-color: <?= $col_colors['created_by'] ?> !important;"><?= htmlspecialchars($user_list[$r['created_by']] ?? 'N/A') ?></td>
                    <td class="small text-center text-muted" style="background-color: <?= $col_colors['created_at'] ?> !important;"><?= date('Y-m-d', strtotime($r['created_at'])) ?></td>
                    
                    <td class="text-center" style="background-color: #f8f9fa !important;">
                        <?php if ($_SESSION['user']['role'] === 'super_admin'): ?>
                            <a href="edit_product.php?id=<?= $r['id'] ?>" class="btn btn-sm btn-info me-1 py-0">تعديل</a>
                            <button onclick="deleteProduct(<?= $r['id'] ?>)" class="btn btn-sm btn-danger py-0">حذف</button>
                        <?php else: ?>
                            <span class="text-muted small">عرض فقط</span>
                        <?php endif; ?>
                    </td>
                </tr>
                <?php endforeach;?>
            </tbody>
        </table>
    </div>
</div>
    
    <script src="https://unpkg.com/@zxing/library@0.18.6/umd/index.min.js"></script>
    <script>
        // 1. كود الحذف (deleteProduct) - كما كان سابقاً
        async function deleteProduct(id) {
            if (!confirm("هل أنت متأكد من حذف المنتج رقم " + id + "؟")) {
                return;
            }
            try {
                const res = await fetch('/barcode-system/api/products.php', {
                    method: 'DELETE',
                    headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                    body: 'id=' + id
                });
                const json = await res.json();
                if (json.ok) {
                    alert("تم حذف المنتج بنجاح.");
                    window.location.reload();
                } else {
                    alert("خطأ في الحذف: " + (json.error || "خطأ غير معروف"));
                }
            } catch (e) {
                alert("حدث خطأ في الاتصال بالخادم.");
            }
        }
        
        // 2. كود المسح الضوئي (الجديد) - يتم إضافته هنا
        const codeReader = new ZXing.BrowserBarcodeReader();
        const video = document.getElementById('video');
        const scanBtn = document.getElementById('scanBtn');
        const barcodeInput = document.getElementById('barcodeInput');
        let active = false;

        scanBtn.addEventListener('click', () => {
            if (active) {
                // إيقاف الكاميرا
                codeReader.reset();
                video.style.display = 'none';
                scanBtn.textContent = 'مسح بالكميرا';
                active = false;
                return;
            }

            // بدء الكاميرا
            video.style.display = 'block';
            scanBtn.textContent = 'إيقاف الكاميرا';
            active = true;

            codeReader.decodeFromVideoDevice(undefined, video, (result, err) => {
                if (result) {
                    barcodeInput.value = result.text.trim();
                    
                    // إيقاف الكاميرا فوراً بعد القراءة
                    codeReader.reset();
                    video.style.display = 'none';
                    scanBtn.textContent = 'مسح بالكميرا';
                    active = false;
                }

                if (err && !(err instanceof ZXing.NotFoundException)) {
                    console.error(err);
                }
            });
        });

    </script>
</body>
</html>