<?php
require_once __DIR__ . '/../init.php';

// التحقق من صلاحيات المدير العام فقط (Super Admin)
if (!isset($_SESSION['user']) || $_SESSION['user']['role'] !== 'super_admin') {
    header('Location: /barcode-system/admin/index.php');
    exit;
}

$message = '';
$message_type = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username'] ?? '');
    $password = $_POST['password'] ?? '';
    $role = $_POST['role'] ?? 'user';

    if (empty($username) || empty($password)) {
        $message = 'الرجاء إدخال اسم المستخدم وكلمة المرور.';
        $message_type = 'danger';
    } elseif (strlen($password) < 6) {
        $message = 'يجب أن لا تقل كلمة المرور عن 6 أحرف.';
        $message_type = 'danger';
    } elseif (!in_array($role, ['super_admin', 'admin', 'user'])) {
        $message = 'صلاحية المستخدم غير صالحة.';
        $message_type = 'danger';
    } else {
        // التحقق من وجود اسم المستخدم مسبقاً
        $check_stmt = $pdo->prepare('SELECT id FROM users WHERE username = ?');
        $check_stmt->execute([$username]);
        
        if ($check_stmt->fetch()) {
            $message = 'اسم المستخدم موجود بالفعل. الرجاء اختيار اسم آخر.';
            $message_type = 'danger';
        } else {
            // تشفير كلمة المرور وحفظ المستخدم
            $password_hash = password_hash($password, PASSWORD_DEFAULT);
            
            try {
                $insert_stmt = $pdo->prepare('INSERT INTO users (username, password_hash, role) VALUES (?, ?, ?)');
                $insert_stmt->execute([$username, $password_hash, $role]);

                $message = 'تم إنشاء المستخدم **' . htmlspecialchars($username) . '** بصلاحية **' . htmlspecialchars($role) . '** بنجاح.';
                $message_type = 'success';
                
            } catch(\PDOException $e) {
                $message = 'حدث خطأ في قاعدة البيانات: ' . $e->getMessage();
                $message_type = 'danger';
            }
        }
    }
}
?>
<!doctype html>
<html lang="ar">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title>إضافة مستخدم جديد</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body{font-family:Tajawal,sans-serif;background:#f6f8fa;padding:16px;direction:rtl;}
        .card{border-radius:12px;padding:30px;margin-bottom:16px;box-shadow:0 6px 18px rgba(0,0,0,0.1);}
        .form-control, .form-select {border-radius: 8px;}
        .btn {border-radius: 8px;}
    </style>
</head>
<body>
    <div class="container">
        <div class="card" style="max-width: 500px; margin: 50px auto;">
            <h4 class="mb-4 text-center text-primary">إنشاء حساب جديد</h4>

            <?php if ($message): ?>
                <div class="alert alert-<?= $message_type ?>"><?= $message ?></div>
            <?php endif; ?>
            
            <form method="post">
                <div class="mb-3">
                    <label class="form-label">اسم المستخدم (Username)</label>
                    <input type="text" name="username" class="form-control" required placeholder="أدخل اسم المستخدم">
                </div>
                <div class="mb-3">
                    <label class="form-label">كلمة المرور</label>
                    <input type="password" name="password" class="form-control" required minlength="6" placeholder="يجب أن لا تقل عن 6 أحرف">
                </div>
                <div class="mb-4">
                    <label class="form-label">الصلاحية</label>
                    <select name="role" class="form-select">
                        <option value="admin">مدير (إضافة/عرض المنتجات)</option>
                        <option value="super_admin">مدير عام (صلاحيات كاملة)</option>
                        <option value="user">مستخدم عادي (عرض فقط - بدون لوحة إدارة)</option>
                    </select>
                </div>
                <div class="d-grid gap-2">
                    <button type="submit" class="btn btn-primary btn-lg">إنشاء المستخدم</button>
                    <a href="/barcode-system/admin/index.php" class="btn btn-outline-secondary">العودة للوحة الإدارة</a>
                </div>
            </form>
        </div>
    </div>
</body>
</html>