<?php
// FILE: view_delivery_notes.php - لعرض سجلات السندات المُسجلة بواسطة المندوب الحالي فقط
require_once __DIR__ . '/init.php';

// 🛑 التحقق من صلاحية مندوب التسليم فقط
if (!isset($_SESSION['user']) || $_SESSION['user']['role'] !== 'delivery_agent') {
    // توجيه غير المصرح لهم لصفحة الدخول
    header('Location: ' . $config['base_url'] . 'login.php');
    exit;
}

// 🎯 جلب ID المندوب الحالي من الجلسة
$current_agent_id = $_SESSION['user']['id'];

// 1. جلب أرقام السندات الفريدة مع عدد المنتجات وتاريخ أول تسليم لها
$stmt = $pdo->prepare("
    SELECT
        delivery_note_ref, MIN(delivery_date) AS delivery_date, COUNT(id) AS product_count
    FROM
        products
    WHERE
        delivery_note_ref IS NOT NULL AND delivery_note_ref != ''
        AND delivery_recorded_by = ?
    GROUP BY
        delivery_note_ref
    ORDER BY
        delivery_date DESC, delivery_note_ref DESC
");
$stmt->execute([$current_agent_id]);
$delivery_notes = $stmt->fetchAll(PDO::FETCH_ASSOC);

$username = htmlspecialchars($_SESSION['user']['username']);
?>

<!doctype html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>سجل التسليم الخاص بي</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body { font-family: 'Tajawal', sans-serif; background: #e9ecef; direction: rtl; }
        .card { border-radius: 15px; box-shadow: 0 4px 15px rgba(0,0,0,0.1); }
    </style>
</head>
<body>
    <div class="container mt-5">
        <div class="card p-4">
            <h1 class="text-center text-info mb-4">سجل سندات التسليم الخاص بـ **<?= $username ?>**</h1>
            <p class="lead text-center">قائمة بجميع سندات التسليم التي سجلتها.</p>
            <hr>

            <div class="d-flex justify-content-between mb-3">
                <a href="/barcode-system/delivery_dashboard.php" class="btn btn-secondary">← تسجيل سند جديد</a>
                <span class="badge bg-primary fs-6">عدد السندات: <?= count($delivery_notes) ?></span>
            </div>
            
            <?php if (empty($delivery_notes)): ?>
                <div class="alert alert-warning text-center">
                    لا توجد سجلات سندات تسليم مدخلة بواسطة حسابك بعد.
                </div>
            <?php else: ?>
                <div class="table-responsive">
                    <table class="table table-striped table-hover">
                        <thead class="table-dark">
                            <tr>
                                <th>رقم السند</th>
                                <th>عدد المنتجات</th>
                                <th>تاريخ التسليم</th>
                                <th>الإجراء</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($delivery_notes as $note): ?>
                            <tr>
                                <td class="fw-bold text-success"><?= htmlspecialchars($note['delivery_note_ref']) ?></td>
                                <td><?= $note['product_count'] ?></td>
                                <td><?= htmlspecialchars($note['delivery_date']) ?></td>
                                <td>
                                    <button 
                                        class="btn btn-sm btn-info text-white" 
                                        onclick="viewDetails('<?= htmlspecialchars($note['delivery_note_ref']) ?>')"
                                    >
                                        عرض التفاصيل
                                    </button>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            <?php endif; ?>
        </div>
    </div>
    
    <script>
    function viewDetails(noteRef) {
        // يتم التحويل إلى صفحة view_note_details.php وتمرير رقم السند كـ GET variable
        const detailPageUrl = 'view_note_details.php?note_ref=' + encodeURIComponent(noteRef);
        window.location.href = detailPageUrl;
    }
    </script>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>