<?php
// hash_test.php

$stored_hash = '$2y$10$7793h7pXfX2O9R0eJq3h5OzJt0U3hY8r.c2n0n2.aG2u8o4v2e4n2'; 
$test_password = 'Admin@00000';

if (password_verify($test_password, $stored_hash)) {
    echo "<h1>✅ نجاح: كلمة المرور تتطابق مع التشفير المخزن.</h1>";
    echo "<p>هذا يعني أن المشكلة ليست في التشفير أو التخزين، بل في الاتصال بقاعدة البيانات أو الجلسات.</p>";
} else {
    // إذا ظهرت هذه الرسالة، فهناك مشكلة في التشفير. يجب إعادة إنشاء المستخدم.
    echo "<h1>❌ فشل: كلمة المرور لا تتطابق مع التشفير المخزن.</h1>";
    
    // الحل: قم بتوليد قيمة تشفير جديدة لكلمة المرور الخاصة بك
    $new_hash = password_hash($test_password, PASSWORD_DEFAULT);
    
    echo "<h2>الحل: استخدم القيمة المشفرة الجديدة أدناه في قاعدة البيانات:</h2>";
    echo "<p>قم بنسخ هذه القيمة ولصقها يدويًا في عمود <strong>password_hash</strong> لصف المستخدم 'admin' في جدول <strong>users</strong>:</p>";
    echo "<strong>القيمة المشفرة الجديدة:</strong> <code>" . $new_hash . "</code>";

    // يمكنك استخدام أمر SQL لتحديثها مباشرة:
    $sql = "UPDATE users SET password_hash = '" . $new_hash . "' WHERE username = 'admin'";
    echo "<h2>أمر SQL للتحديث المباشر:</h2>";
    echo "<code>" . htmlspecialchars($sql) . "</code>";
}
?>