<?php
require_once __DIR__ . '/../init.php';

// 1. التحقق من صلاحيات الدخول: مسموح لـ super_admin و admin (أو أي دور آخر مسموح له بالعرض)
if (!isset($_SESSION['user']) || ($_SESSION['user']['role'] !== 'super_admin' && $_SESSION['user']['role'] !== 'admin')) {
    header('Location: /barcode-system/admin/login.php');
    exit;
}

// 🛑 إعدادات الترقيم (Pagination) 🛑
$products_per_page = 10;
$current_page = max(1, intval($_GET['page'] ?? 1)); // تأكد من أن الصفحة لا تقل عن 1

// 🎯 (أ) جلب العدد الكلي للمنتجات
$total_products_stmt = $pdo->query("SELECT COUNT(*) FROM products");
$total_products = $total_products_stmt->fetchColumn();

// 🎯 (ب) حساب عدد الصفحات الكلي
$total_pages = ceil($total_products / $products_per_page);

// 🎯 (ت) حساب نقطة البداية (OFFSET)
$start_from = ($current_page - 1) * $products_per_page;
if($start_from < 0) $start_from = 0;

// 🎯 (ث) استعلام جلب المنتجات المحدود (مع الترتيب والتحديد)
$rows = $pdo->query("
    SELECT *, delivery_note_ref, delivery_date 
    FROM products 
    ORDER BY created_at DESC 
    LIMIT $start_from, $products_per_page
")->fetchAll(PDO::FETCH_ASSOC);

// قائمة المستخدمين لاستخدامها في الجدول
$user_list = $pdo->query("SELECT id, username FROM users")->fetchAll(PDO::FETCH_KEY_PAIR);

// تحديد دور المستخدم لتحديد إجراءات التعديل/الحذف
$user_role = $_SESSION['user']['role'] ?? 'admin'; 
?>
<!doctype html>
<html lang="ar">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title>قائمة المنتجات - Backcare</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
<style>
    body{font-family:Tajawal,sans-serif;background:#f8f9fa;padding:16px;direction:rtl;}
    .card{border-radius:12px;padding:16px;margin-bottom:16px;box-shadow:0 4px 12px rgba(0,0,0,0.05);}
    .table-responsive{overflow-x:auto;}
</style>
</head>
<body>
    <div class="container">
        
        <div class="mb-3 d-flex justify-content-between align-items-center">
            <h2 class="h4">قائمة المنتجات المفصلة</h2>
            <a href="/barcode-system/admin/index.php" class="btn btn-primary btn-sm">
                <i class="bi bi-arrow-right-short"></i> العودة للإدارة/الإضافة
            </a>
        </div>
        
        <?php 
        // تعريف الألوان الفاتحة للأعمدة
        $col_colors = [
            'id' => '#f8f9fa',
            'barcode' => '#e6f0ff',
            'name' => '#ffffff',
            'size' => '#e6fffd',
            'production_date' => '#fffbe6',
            'notes' => '#f5f5f5',
            'created_by' => '#e6f7ff',
            'created_at' => '#e6e6ff',
            'delivery_note_ref' => '#d0e0fb',
            'delivery_date' => '#e6ffef',
        ];
        ?>

        <div class="card">
            <h4 class="mb-3">السجلات (<span class="text-primary"><?= $total_products ?></span>) - الصفحة الحالية: <?= $current_page ?></h4>
            <div class="table-responsive">
                <table class="table table-hover table-sm">
                    
                    <thead style="font-size: 0.9rem;">
                        <tr style="border-bottom: 3px solid #ccc;">
                            <th scope="col" class="text-white text-center" style="width: 50px; background-color: #6c757d !important;">ID</th>
                            <th scope="col" class="text-white text-center" style="background-color: #0d6efd !important;">الباركود</th>
                            <th scope="col" class="text-white" style="background-color: #198754 !important;">الاسم</th>
                            <th scope="col" class="text-white text-center" style="width: 80px; background-color: #20c997 !important;">المقاس</th>
                            <th scope="col" class="text-center" style="background-color: #ffc107 !important; color: #333 !important;">تاريخ انتاج</th>
                            <th scope="col" class="text-white text-center" style="background-color: #007bff !important;">رقم السند</th>
                            <th scope="col" class="text-white text-center" style="background-color: #28a745 !important;">تاريخ التسليم</th>
                            <th scope="col" class="text-white" style="background-color: #6f42c1 !important;">الملاحظات</th>
                            <th scope="col" class="text-center" style="background-color: #0dcaf0 !important; color: #333 !important;">بواسطة</th>
                            <th scope="col" class="text-white text-center" style="background-color: #000080 !important;">تاريخ الإنشاء</th>
                            <th scope="col" class="text-white text-center" style="width: 120px; background-color: #343a40 !important;">إجراءات</th>
                        </tr>
                    </thead>
                    
                    <tbody>
                        <?php foreach($rows as $r): ?>
                        <tr>
                            <td class="small text-center" style="background-color: <?= $col_colors['id'] ?> !important;"><?= $r['id'] ?></td>
                            <td class="small text-center text-break" style="background-color: <?= $col_colors['barcode'] ?> !important;"><strong><?= htmlspecialchars($r['barcode']) ?></strong></td>
                            <td class="small" style="background-color: <?= $col_colors['name'] ?> !important;"><?= htmlspecialchars($r['name']) ?></td>
                            <td class="small text-center" style="background-color: <?= $col_colors['size'] ?> !important;"><?= htmlspecialchars($r['size'] ?? '-') ?></td>
                            <td class="small text-center" style="background-color: <?= $col_colors['production_date'] ?> !important;"><?= htmlspecialchars($r['production_date'] ?? '-') ?></td>
                            
                            <td class="small text-center fw-bold" style="background-color: <?= $col_colors['delivery_note_ref'] ?> !important;">
                                <?= htmlspecialchars($r['delivery_note_ref'] ?? '-') ?>
                            </td>
                            <td class="small text-center" style="background-color: <?= $col_colors['delivery_date'] ?> !important;">
                                <?= htmlspecialchars($r['delivery_date'] ?? '-') ?>
                            </td>
                            
                            <td class="small" style="background-color: <?= $col_colors['notes'] ?> !important;">
                                <div class="text-truncate" style="max-width: 150px;" title="<?= htmlspecialchars($r['notes'] ?: 'لا توجد ملاحظات') ?>">
                                    <?= htmlspecialchars($r['notes'] ?? '-') ?>
                                </div>
                            </td>
                            
                            <td class="small text-center text-muted" style="background-color: <?= $col_colors['created_by'] ?> !important;"><?= htmlspecialchars($user_list[$r['created_by']] ?? 'N/A') ?></td>
                            <td class="small text-center text-muted" style="background-color: <?= $col_colors['created_at'] ?> !important;"><?= date('Y-m-d', strtotime($r['created_at'])) ?></td>
                            
                            <td class="text-center" style="background-color: #f8f9fa !important;">
                                <?php if ($user_role === 'super_admin'): ?>
                                    <a href="edit_product.php?id=<?= $r['id'] ?>" class="btn btn-sm btn-info me-1 py-0">تعديل</a>
                                    <button onclick="deleteProduct(<?= $r['id'] ?>)" class="btn btn-sm btn-danger py-0">حذف</button>
                                <?php else: ?>
                                    <a href="edit_product.php?id=<?= $r['id'] ?>" class="btn btn-sm btn-info me-1 py-0">عرض</a>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach;?>
                    </tbody>
                </table>
            </div>
            
            <?php if ($total_pages > 1): ?>
            <nav aria-label="Products Pagination">
                <ul class="pagination justify-content-center mt-4 flex-wrap">
                    
                    <li class="page-item <?= ($current_page <= 1) ? 'disabled' : '' ?>">
                        <a class="page-link" href="?page=1">الصفحة الأولى</a>
                    </li>

                    <li class="page-item <?= ($current_page <= 1) ? 'disabled' : '' ?>">
                        <a class="page-link" href="?page=<?= max(1, $current_page - 1) ?>" aria-label="Previous">
                            <span aria-hidden="true">&laquo;</span>
                        </a>
                    </li>
                    
                    <?php
                    // تحديد نطاق الأرقام المعروضة (5 صفحات حول الصفحة الحالية)
                    $range = 2;
                    $start_loop = max(1, $current_page - $range);
                    $end_loop = min($total_pages, $current_page + $range);
                    
                    if ($start_loop > 1) { echo '<li class="page-item disabled"><span class="page-link">...</span></li>'; }
                    
                    for ($i = $start_loop; $i <= $end_loop; $i++): 
                    ?>
                        <li class="page-item <?= ($i == $current_page) ? 'active' : '' ?>">
                            <a class="page-link" href="?page=<?= $i ?>"><?= $i ?></a>
                        </li>
                    <?php endfor;
                    
                    if ($end_loop < $total_pages) { echo '<li class="page-item disabled"><span class="page-link">...</span></li>'; }
                    ?>
                    
                    <li class="page-item <?= ($current_page >= $total_pages) ? 'disabled' : '' ?>">
                        <a class="page-link" href="?page=<?= min($total_pages, $current_page + 1) ?>" aria-label="Next">
                            <span aria-hidden="true">&raquo;</span>
                        </a>
                    </li>
                    
                    <li class="page-item <?= ($current_page >= $total_pages) ? 'disabled' : '' ?>">
                        <a class="page-link" href="?page=<?= $total_pages ?>">الصفحة الأخيرة</a>
                    </li>
                </ul>
            </nav>
            <?php endif; ?>

        </div>
    </div>
    
    <script>
        async function deleteProduct(id) {
            if (!confirm("هل أنت متأكد من حذف المنتج رقم " + id + "؟")) {
                return;
            }
            try {
                const res = await fetch('/barcode-system/api/products.php', {
                    method: 'DELETE',
                    headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                    body: 'id=' + id
                });
                const json = await res.json();
                if (json.ok) {
                    alert("تم حذف المنتج بنجاح.");
                    window.location.reload();
                } else {
                    alert("خطأ في الحذف: " + (json.error || "خطأ غير معروف"));
                }
            } catch (e) {
                alert("حدث خطأ في الاتصال بالخادم.");
            }
        }
    </script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>