<?php
// FILE: admin/generate_temporary_barcodes.php
require_once __DIR__ . '/../init.php';

// 🛑 التحقق من صلاحيات المدير
if (!isset($_SESSION['user']) || ($_SESSION['user']['role'] !== 'super_admin' && $_SESSION['user']['role'] !== 'admin')) {
    header('Location: ' . $config['base_url'] . 'admin/index.php');
    exit;
}

// ⚙️ إعدادات توليد الباركود
$total_barcodes = 100000; // يمكنك تغيير هذا العدد كما تشاء
// $prefix = 'BC';  // بادئة الباركود المطلوبة (BC)
$prefix = 'BC' . date(ymd) ;  // بادئة الباركود المطلوبة (BC)


// 🆕 متغيرات التحكم في الطباعة
// رقم البداية: القيمة الافتراضية 1 أو القيمة المدخلة من المستخدم
$start_number_input = isset($_GET['start']) ? (int)$_GET['start'] : 1;
if ($start_number_input < 1) $start_number_input = 1;

// عدد الصفحات المراد دمجها وعرضها للطباعة
$print_pages_count = isset($_GET['print_count']) ? (int)$_GET['print_count'] : 1;
if ($print_pages_count < 1) $print_pages_count = 1;
// الحد الأقصى للطباعة المدمجة
if ($print_pages_count > 100) $print_pages_count = 100; 

// 🛑 حساب رقم البداية الفعلي
$limit = 100; // 100 باركود في الصفحة الواحدة
$total_pages = ceil($total_barcodes / $limit);

$page = isset($_GET['p']) ? (int)$_GET['p'] : 1;
if ($page < 1) $page = 1;
if ($page > $total_pages) $page = $total_pages;

// حساب إجمالي عدد الباركودات المراد عرضها الآن
$total_limit = $limit * $print_pages_count;

// حساب رقم البداية الفعلي لـ *أول* صفحة
$current_page_index = (($page - 1) * $limit);

// رقم البداية الفعلي لتوليد الباركود
$actual_start_number = $start_number_input + $current_page_index;

$barcodes = [];
// توليد الباركودات المطلوبة لجميع الصفحات المحددة
for ($i = 0; $i < $total_limit; $i++) {
    $current_number = $actual_start_number + $i;
    
    // توقف إذا تجاوزنا العدد الإجمالي المطلوب (من نقطة البداية)
    if (($current_number - $start_number_input) >= $total_barcodes) break;
    
    // تنسيق الرقم ليكون طوله ثابتاً (7 أرقام: BC0000001)
    $number_string = str_pad($current_number, 7, '0', STR_PAD_LEFT);
    $barcodes[] = $prefix . $number_string;
}

?>
<!doctype html>
<html lang="ar">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title>طباعة باركودات غير مسجلة</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/jsbarcode@3.11.6/dist/JsBarcode.all.min.js"></script>
    <style>
        body { font-family: Tahoma, Arial, sans-serif; direction: rtl; padding: 20px; }
        .barcode-container {
            display: inline-block;
            margin: 20px 15px;
            text-align: center;
            border: 1px solid #ddd;
            padding: 10px;
            width: 150px; /* عرض ثابت للملصق */
            max-width: 100%;
            border-radius: 6px;
            box-shadow: 0 3px 8px rgba(0,0,0,0.05);
        }
        /* 🛑 ضمان احتواء صورة الباركود SVG داخل الحاوية */
        .barcode-container svg {
            width: 100%;
            height: auto;
            display: block;
            margin: 0;
            padding: 0;
        }
        .barcode-text {
            font-size: 11px;
            margin-top: 8px;
            font-weight: bold;
            color: #333;
            word-break: break-all;
        }
        @media print {
            body { 
                padding: 0; 
                margin: 0;
            }
            .no-print {
                display: none !important;
            }
            .barcode-container {
                page-break-inside: avoid; /* منع كسر الملصق أثناء الطباعة */
                margin: 10px 8px;
                box-shadow: none;
                border: 1px solid #000;
            }
        }
    </style>
</head>
<body>
    <div class="container-fluid">
       
           <div class="no-print mb-4">

    <div class="card bg-info text-white shadow-sm mb-3" style="margin-top: -15px;">
        <div class="card-body p-2 text-center">
            <h6 class="mb-0 fw-bold">
                📄 طباعة باركودات مُعدَّة مسبقاً (الصفحة: <?= $page ?> من <?= $total_pages ?>)
            </h6>
        </div>
    </div>
    <form class="d-flex align-items-end mb-3 flex-wrap" method="get">
        
        <div class="me-4 mb-2">
            <label for="start" class="form-label small fw-bold text-primary">🔢 توليد باركودات جديدة ابتداء من:</label>
            <input type="number" id="start" name="start" value="<?= htmlspecialchars($start_number_input) ?>" 
                   class="form-control form-control-sm" style="width: 250px;" min="1" required>
        </div>
        
        <div class="me-3 mb-2">
            <label for="print_count" class="form-label small fw-bold text-success">📄 عدد الصفحات للطباعة (الحد الأقصى 100):</label>
            <input type="number" id="print_count" name="print_count" value="<?= htmlspecialchars($print_pages_count) ?>" 
                   class="form-control form-control-sm" style="width: 250px;" min="1" max="100" required>
        </div>
        
        <div class="mb-2">
            <input type="hidden" name="p" value="<?= $page ?>"> 
            <button type="submit" class="btn btn-warning btn-sm" style="height: 31px;">انتقال / تحديث</button>
        </div>
    </form>
    <a href="/barcode-system/admin/index.php" class="btn btn-secondary me-2">العودة للوحة الإدارة</a>
    <button onclick="window.print()" class="btn btn-primary me-2">🖨️ طباعة الملصقات المعروضة (<?= count($barcodes) ?> باركود)</button>
    
    <p class="mt-2 text-danger fw-bold">⚠️ تحذير: اختيار 100 صفحة قد يتسبب في بطء أو توقف المتصفح عن العمل. يفضل الطباعة على دفعات صغيرة.</p>
    <p class="mt-1 text-danger">ملاحظة: هذه الباركودات غير مسجلة في قاعدة البيانات حالياً. العدد الإجمالي: <?= number_format($total_barcodes) ?></p>
</div>

        <div>
            <?php foreach ($barcodes as $barcode): ?>
                <div class="barcode-container">
                    <svg id="barcode-<?= htmlspecialchars($barcode) ?>"></svg>
                    <div class="barcode-text"><?= htmlspecialchars($barcode) ?></div>
                </div>
            <?php endforeach; ?>
        </div>

        <nav class="no-print mt-4">
            <ul class="pagination justify-content-center">
                <?php $start_param = '&start=' . $start_number_input . '&print_count=' . $print_pages_count; ?>
                
                <?php if ($page > 1): ?>
                    <li class="page-item"><a class="page-link" href="?p=1<?= $start_param ?>">الأولى</a></li>
                <?php endif; ?>
                
                <?php if ($page > 1): ?>
                    <li class="page-item"><a class="page-link" href="?p=<?= $page - 1 ?><?= $start_param ?>">السابق</a></li>
                <?php endif; ?>
                
                <?php 
                // عرض نطاق محدود من صفحات الترقيم
                $start = max(1, $page - 2);
                $end = min($total_pages, $page + 2);

                for ($i = $start; $i <= $end; $i++): 
                ?>
                    <li class="page-item <?= ($i == $page) ? 'active' : '' ?>">
                        <a class="page-link" href="?p=<?= $i ?><?= $start_param ?>"><?= $i ?></a>
                    </li>
                <?php endfor; ?>
                
                <?php if ($page < $total_pages): ?>
                    <li class="page-item"><a class="page-link" href="?p=<?= $page + 1 ?><?= $start_param ?>">التالي</a></li>
                <?php endif; ?>

                <?php if ($page < $total_pages): ?>
                    <li class="page-item"><a class="page-link" href="?p=<?= $total_pages ?><?= $start_param ?>">الأخيرة</a></li>
                <?php endif; ?>
            </ul>
        </nav>
        
        <form class="no-print d-flex justify-content-center align-items-center mt-3" method="get">
            <label for="jump_page" class="form-label mb-0 me-2">انتقال لصفحة محددة:</label>
            <input type="number" id="jump_page" name="p" min="1" max="<?= $total_pages ?>" 
                   class="form-control form-control-sm me-2" style="width: 80px;" required>
            <button type="submit" class="btn btn-secondary btn-sm">انتقال</button>
            <input type="hidden" name="start" value="<?= htmlspecialchars($start_number_input) ?>">
            <input type="hidden" name="print_count" value="<?= htmlspecialchars($print_pages_count) ?>">
        </form>

    </div>

    <script>
        document.addEventListener("DOMContentLoaded", function() {
            <?php foreach ($barcodes as $barcode): ?>
                JsBarcode("#barcode-<?= htmlspecialchars($barcode) ?>", "<?= htmlspecialchars($barcode) ?>", {
                    format: "CODE128", 
                    displayValue: false, // لا لعرض النص، نعرضه يدوياً في <div>
                    margin: 0, 
                    width: 1, // عرض نحيف للخطوط ليتناسب مع الحاوية
                    height: 50 // ارتفاع جيد للباركود
                });
            <?php endforeach; ?>
        });
    </script>
</body>
</html>