<?php
// FILE: user/index.php (واجهة المستخدم العادي)
require_once __DIR__ . '/../init.php';
// لا نحتاج لاستعلام جلب الـ 500 صف هنا لأن هذه الواجهة للبحث الفوري فقط
?>
<!doctype html>
<html lang="ar">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>واجهة المستخدم - Backcare</title>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
<style>
body{font-family:Tajawal,sans-serif;background:#f7fbff;padding:0;direction:rtl;}
.main-content { padding: 16px; }
.card{border-radius:12px;padding:16px;margin-bottom:16px;box-shadow:0 4px 12px rgba(0,0,0,0.08);}
#video{border-radius:8px;width:100%;max-width:320px;height:auto;margin-bottom:12px;display:none;}

/* 🟢 تنسيق شريط الشعار (أزرق) */
.header-logo-bar {
    background-color: #007bff; /* أزرق أساسي */
    padding: 10px 16px;
    margin-bottom: 20px ; 
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}
.header-logo-bar img {
    height: 60px; /* حجم الشعار */
    width: auto;
}

/* 🟢 تنسيق شريط العنوان (أحمر) */
.header-title-bar {
    background-color: #dc3545; /* أحمر */
    color: white;
    padding: 10px 20px;
    margin-bottom: 20px ; 
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}
/* 💡 تم التعديل هنا لتوسيط العنوان */
.header-title-bar .container {
    display: flex;
    justify-content: center; /* توسيط أفقي */
}
.header-title-bar h1 {
    font-size: 1.50rem;
    margin: 0 ;
    display: flex;
    align-items: center;
}
.header-title-bar .bi {
    margin-left: 8px;
}

/* 💡 تنسيقات تصميم الإدخال الموحد (مثل واجهة الإدارة) */
.input-group .form-control { 
    border-top-right-radius: 0.375rem !important; 
    border-bottom-right-radius: 0.375rem !important;
    border-top-left-radius: 0 !important;
    border-bottom-left-radius: 0 !important;
    background-color: #f7f9fc !important; 
    border: 1px solid #d1d5db; 
}
.input-group #barcodeInput {
    border-top-left-radius: 0 !important;
    border-bottom-left-radius: 0 !important;
}
/* زر السهم المعقوف (الآن في المنتصف) */
.btn-barcode-submit {
    border-radius: 0 !important; 
    background-color: #4a7dce !important; 
    border-color: #4a7dce !important;
}
/* زر الكاميرا (الآن في أقصى اليسار) */
#scanBtn { 
    border-top-left-radius: 0.375rem !important; 
    border-bottom-left-radius: 0.375rem !important;
    background-color: #209353 !important;
    border-color: #209353 !important;
}

/* 🟢 تنسيق عرض بيانات المنتج (Product Detail) */
.product-detail-card {
    background-color: #e6f7ff; /* لون أزرق سماوي فاتح */
    border: 2px solid #a0c3ff;
    border-radius: 12px;
    padding: 20px;
}
.product-detail-card div {
    margin-bottom: 8px;
    font-size: 1rem;
}
.product-detail-card strong {
    color: #007bff;
    display: inline-block;
    min-width: 120px;
}
.product-detail-card .highlight {
    font-weight: bold;
    color: #28a745;
}
</style>
</head>
<body>

<header class="header-logo-bar">
    <div class="container d-flex justify-content-between align-items-center">
        <img src="/barcode-system/back care LOGO.svg" alt="Backcare Logo">
        
        <?php if (isset($_SESSION['user'])): ?>
            <div>
                <a href="/barcode-system/admin/index.php" class="btn btn-sm btn-light me-2">
                    <i class="bi bi-gear-fill"></i> الإدارة
                </a>
                <a href="/barcode-system/auth.php?action=logout" class="btn btn-sm btn-warning">
                    <i class="bi bi-box-arrow-right"></i> خروج
                </a>
            </div>
        <?php else: ?>
            <a href="/barcode-system/admin/login.php" class="btn btn-sm btn-info text-white">
                <i class="bi bi-person-fill"></i> تسجيل الدخول
            </a>
        <?php endif; ?>
    </div>
</header>

<div class="header-title-bar">
    <div class="container">
        <h1>
            <i class="bi bi-search"></i>
            الاستعلام عن منتج
        </h1>
    </div>
</div>

<div class="container main-content">
    <div class="card">
        
        <p class="text-muted">أدخل الباركود يدوياً أو استخدم الكاميرا للمسح الضوئي.</p>
        
        <div class="input-group mb-3">
            <input type="text" id="barcodeInput" class="form-control" placeholder="أدخل الباركود ">
            
            <button class="btn btn-primary btn-barcode-submit" id="searchBtn" title="بحث يدوي">
                <i class="bi bi-arrow-return-left"></i>
            </button>
            
            <button class="btn btn-success" id="scanBtn" title="مسح بالكاميرا">
                <i class="bi bi-camera-fill"></i>
            </button>
        </div>
        
        <video id="video" autoplay></video>
        
        <div id="productData">
            </div>
    </div>
</div>

<script src="https://unpkg.com/@zxing/library@0.18.6/umd/index.min.js"></script>
<script>
const codeReader = new ZXing.BrowserBarcodeReader();
const video = document.getElementById('video');
const scanBtn = document.getElementById('scanBtn');
const searchBtn = document.getElementById('searchBtn'); 
const barcodeInput = document.getElementById('barcodeInput');
const prodDiv = document.getElementById('productData');
const scanBtnIcon = scanBtn.querySelector('i');
let active = false;

// 1. دالة جلب وعرض المنتج
function fetchProduct(barcode){
    if (!barcode) {
        prodDiv.innerHTML = `<div class="alert alert-warning">الرجاء إدخال رمز الباركود.</div>`;
        return;
    }
    
    // عرض رسالة بحث مؤقتة
    prodDiv.innerHTML = `<div class="alert alert-info">جاري البحث عن ${barcode}...</div>`;

    fetch('/barcode-system/api/products.php', {
        method:'POST',
        headers:{'Content-Type':'application/json'},
        body: JSON.stringify({barcode: barcode})
    }).then(r=>r.json()).then(j=>{
        if(j.error){
            prodDiv.innerHTML = `<div class="product-detail-card alert-danger">
                                    <h5 class="text-danger">❌ لم يتم العثور على المنتج</h5>
                                    <p>لا يوجد منتج مسجل بالباركود: <strong>${barcode}</strong></p>
                                </div>`;
        } else {
            // كود العرض المحدث والمنظم
            let html=`<div class="product-detail-card">
                        <h5 class="text-primary">✅ تم العثور على المنتج</h5>
                        <hr>
                        <div><strong>الاسم:</strong> <span class="highlight">${j.name}</span></div>
                        <div><strong>الباركود:</strong> ${j.barcode}</div>
                        <div><strong>المقاس:</strong> ${j.size || '-'}</div>
                        <div><strong>تاريخ الإنتاج:</strong> ${j.production_date || '-'}</div>
                        <div><strong>تاريخ الانتهاء:</strong> ${j.expiry_date || '-'}</div>
                        <hr>
                        <div><strong>رقم السند:</strong> <span class="fw-bold text-success">${j.delivery_note_ref || 'لم يتم التسليم بعد'}</span></div>
                        <div><strong>تاريخ التسليم:</strong> <span class="fw-bold text-success">${j.delivery_date || '-'}</span></div>
                        <hr>
                        <div><strong>ملاحظات:</strong> ${j.notes || 'لا توجد ملاحظات'}</div>
                      </div>`;
            prodDiv.innerHTML = html;
        }
    }).catch(e=>{
        prodDiv.innerHTML=`<div class="product-detail-card alert-danger">
                            <h5 class="text-danger">⚠️ خطأ في الاتصال</h5>
                            حدث خطأ أثناء جلب البيانات.
                          </div>`;
    });
}

// 2. معالج حدث زر المسح بالكاميرا
scanBtn.addEventListener('click', ()=>{
    if(active){
        codeReader.reset();
        video.style.display='none';
        scanBtnIcon.className = 'bi bi-camera-fill';
        active=false;
        return;
    }
    video.style.display='block';
    scanBtnIcon.className = 'bi bi-camera-video-fill';
    active=true;
    codeReader.decodeFromVideoDevice(undefined, video, (result, err)=>{
        if(result){
            barcodeInput.value = result.text.trim();
            fetchProduct(result.text.trim());
            
            // إيقاف الكاميرا بعد المسح الناجح
            codeReader.reset();
            video.style.display='none';
            scanBtnIcon.className = 'bi bi-camera-fill';
            active=false;
        }
    }).catch(err=>{
        prodDiv.innerHTML = `<div class="alert alert-danger">فشل الوصول للكاميرا. تأكد من إعطاء الصلاحيات.</div>`;
        video.style.display='none';
        scanBtnIcon.className = 'bi bi-camera-fill';
        active=false;
    });
});

// 3. معالج حدث زر البحث اليدوي (السهم المعقوف)
searchBtn.addEventListener('click', ()=>{
    fetchProduct(barcodeInput.value.trim());
});

// 4. البحث عند الضغط على Enter في حقل الإدخال
barcodeInput.addEventListener('keypress', (e) => {
    if (e.key === 'Enter') {
        e.preventDefault(); 
        fetchProduct(barcodeInput.value.trim());
    }
});
</script>
</body>
</html>