<?php
// FILE: delivery_dashboard.php (واجهة إضافة سند تسليم - مُحسَّنة ومُركَّزة - تم إصلاح مشكلة Enter)
require_once __DIR__ . '/init.php';

// 🛑 التحقق من صلاحية مندوب التسليم فقط
if (!isset($_SESSION['user']) || $_SESSION['user']['role'] !== 'delivery_agent') {
    header('Location: ' . $config['base_url'] . 'login.php');
    exit;
}

$username = htmlspecialchars($_SESSION['user']['username']);
$user_id = $_SESSION['user']['id']; 
?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title>إضافة سند تسليم</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css" rel="stylesheet">
    <style>
        body{font-family:'Tajawal',sans-serif;background:#f4f7f9;padding:16px;direction:rtl;}
        .card{border-radius:12px;padding:20px;margin-bottom:20px;box-shadow:0 6px 20px rgba(0,0,0,0.1);}
        
        /* 💡 تنسيق الحقول الملونة */
        .form-control:not(.disabled-input) {
            background-color: #f0f8ff; /* لون أزرق فاتح جداً */
            border: 1px solid #cce5ff;
        }

        /* 💡 تنسيق شريط الشعار (أصبح في الأعلى: حواف مدورة علوية) */
        .header-logo-bar {
            min-height: 60px; /* الارتفاع المطلوب */
            padding: 8px 15px; 
            background-color: #0d6efd !important; /* لون أزرق أساسي */
            
            /* تم نقل حواف التدوير العلوية إلى هنا */
            border-top-left-radius: 12px;
            border-top-right-radius: 12px;
            border-bottom-left-radius: 0 !important; /* إزالة تدوير الحواف السفلية ليتصل بالعنوان */
            border-bottom-right-radius: 0 !important;
            
            /* ليغطي عرض الكارد كاملاً في الأعلى */
            margin: -20px -20px 5px -20px; 
            width: auto%; 
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
        }
        .logo-header {
            max-height: 60px;
            width: auto;
        }
        
        /* 💡 تنسيق شريط العنوان الجديد (أصبح في الأسفل: حواف مدورة سفلية ومسافة بعده) */
        .title-bar {
            background-color: #b40000; /* أحمر داكن (Danger) */
            color: white;
            padding: 8px 15px; /* ارتفاع أقل */
            text-align: center;
            
            /* إزالة تدوير الحواف العلوية ليتصل بالشعار */
            border-top-left-radius: 0;
            border-top-right-radius: 0;
            /* إضافة تدوير الحواف السفلية ليغلق الجزء العلوي من الكارد */
            border-bottom-left-radius: 12px;
            border-bottom-right-radius: 12px;
            
            /* يربط بالشريط العلوي ثم يضيف مسافة سفلية قبل محتوى الكارد */
            margin: 0 -20px 20px -20px; 
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
        }
        .title-bar h1 {
            font-size: 1.4rem; 
            font-weight: bold;
            margin: 0;
        }

        /* تنسيق المنتجات */
        .products-group {
            border: 2px solid #0d6efd;
            border-radius: 10px; 
            padding: 15px; 
            margin-bottom: 20px; 
            background-color: #f7faff;
        }
        .product-item { 
            border: 1px solid #d1e7dd;
            border-radius: 8px; 
            padding: 15px; 
            margin-bottom: 10px; 
            background-color: #ffffff; 
        }
        
        /* تنسيق الحقول المعطلة */
        .disabled-input { 
            background-color: #e9ecef !important; 
            color: #6c757d;
            border-left: 5px solid #0d6efd;
        }
        
        /* توحيد أزرار الكاميرا */
        .camera-btn { 
            height: 38px;
            width: 38px;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 0;
        }
        
        /* تنسيق حاوية الفيديو */
        .video-container {
            width: 100%;
            max-width: 320px;
            height: auto;
            border: 2px solid #dc3545;
            border-radius: 8px;
            margin-top: 10px;
            display: none;
        }
        .video-container video {
            width: 100%;
            height: auto;
            border-radius: 6px;
        }
        
        /* تحسين شريط الأزرار السفلية على الجوال */
        .footer-actions {
            display: flex;
            justify-content: space-between;
            align-items: center;
            gap: 10px;
            flex-wrap: wrap;
        }

        @media (max-width: 767.98px) {
            .footer-actions {
                flex-direction: column;
                align-items: stretch;
            }
            .footer-actions > * {
                margin-bottom: 10px;
                width: 100%;
            }
        }
        
        /* تنسيق زر سجل التسليم ليكون أزرق بارز */
        .btn-records {
            background-color: #0d6efd; /* أزرق أساسي */
            border-color: #0d6efd;
            color: #fff;
        }
        .btn-records:hover {
            background-color: #0b5ed7; /* أزرق أغمق عند التمرير */
            border-color: #0a58ca;
            color: #fff;
        }

    </style>
</head>
<body>
    <div class="container mt-5">
        
        <div class="d-flex justify-content-end mb-3">
            <span class="badge bg-dark p-2 shadow-sm">
                <i class="bi bi-person-fill me-1"></i> المندوب: <?= $username ?>
            </span>
        </div>

        <div class="card bg-white">
            
            <div class="header-logo-bar d-flex justify-content-center align-items-center">
                
                <img src="/barcode-system/back care LOGO.svg " alt="شعار باك كير" class="logo-header">
                
            </div>

            <div class="title-bar">
                <h1>
                    <i class="bi bi-receipt me-2"></i> إضافة سند تسليم
                </h1>
            </div>
            
            <div id="statusMessage" class="mt-3 mb-3"></div>

            <form id="multiDeliveryForm">
                
                <div class="row mb-4 p-3 border-start border-3 border-success bg-light rounded">
                    <div class="col-md-6 mb-3">
                        <label for="delivery_note_ref" class="form-label fw-bold">رقم سند التسليم</label>
                        <div class="input-group">
                            <input type="text" class="form-control" id="delivery_note_ref" name="delivery_note_ref" required placeholder="أدخل أو امسح رقم السند">
                            <button type="button" class="btn btn-primary camera-btn" id="scanNoteBtn" title="مسح رقم السند">
                                <i class="bi bi-camera-fill"></i>
                            </button>
                        </div>
                        <div id="videoContainerNote" class="video-container">
                            <video id="videoNote" autoplay></video>
                        </div>
                    </div>

                    <div class="col-md-6 mb-3">
                        <label for="delivery_date" class="form-label fw-bold">تاريخ التسليم الفعلي</label>
                        <?php 
                            $today = date('Y-m-d');
                        ?>
                        <input type="date" class="form-control disabled-input" id="delivery_date" name="delivery_date" 
                               value="<?= $today ?>" required readonly>
                    </div>
                </div>
                
                <hr>

                <div class="products-group">
                    <h5 class="mb-3 text-primary fw-bold">
                        <i class="bi bi-box-seam me-1"></i> المنتجات المراد تسليمها (الباركود)
                    </h5>

                    <div id="productsContainer">
                        </div>
                    
                    <div class="d-flex justify-content-start align-items-center mt-4">
                        <button type="button" class="btn btn-sm btn-outline-secondary me-3" id="addProductBtn">
                            <i class="bi bi-plus-circle-fill me-1"></i> إضافة منتج آخر
                        </button>
                    </div>

                </div>
                
                <div class="footer-actions mt-4 border-top pt-3">
                    <button type="submit" class="btn btn-success btn-lg shadow-sm" id="saveBtn">
                        <i class="bi bi-save-fill me-1"></i> حفظ السند
                    </button>
                    <button type="button" class="btn btn-warning btn-lg shadow-sm" id="newNoteBtn" style="display:none;">
                        <i class="bi bi-plus-lg me-1"></i> سند جديد
                    </button>
                    <a href="/barcode-system/view_delivery_notes.php" class="btn btn-lg shadow-sm btn-records">
                        <i class="bi bi-list-columns me-1"></i> سجل التسليم الخاص بي
                    </a>
                    <a href="/barcode-system/auth.php?action=logout" class="btn btn-danger btn-lg shadow-sm">
                        <i class="bi bi-box-arrow-right me-1"></i> تسجيل خروج
                    </a>
                </div>
            </form>
        </div>
    </div>
    
    <div id="videoContainerBarcode" class="video-container" style="display:none; margin: 10px 0;">
        <video id="videoBarcode" autoplay></video>
    </div>
    
    <script src="https://unpkg.com/@zxing/library@0.18.6/umd/index.min.js"></script>
    <script>
        // ------------------ تعريف المتغيرات ------------------
        const productsContainer = document.getElementById('productsContainer');
        const addProductBtn = document.getElementById('addProductBtn');
        const multiDeliveryForm = document.getElementById('multiDeliveryForm');
        const saveBtn = document.getElementById('saveBtn');
        const newNoteBtn = document.getElementById('newNoteBtn');
        const statusDiv = document.getElementById('statusMessage');

        // متغيرات الفيديو
        const videoNoteContainer = document.getElementById('videoContainerNote');
        const videoNote = document.getElementById('videoNote');
        
        const videoBarcodeContainer = document.getElementById('videoContainerBarcode'); // حاوية فيديو الباركود
        const videoBarcode = document.getElementById('videoBarcode');
        
        const scanNoteBtn = document.getElementById('scanNoteBtn'); 
        
        const API_URL = '/barcode-system/api/delivery.php';
        const SEARCH_URL = '/barcode-system/api/products.php';
        let productCounter = 0;
        let productsData = {}; 
        let scanActive = false;
        let scanNoteActive = false; 
        const codeReader = new ZXing.BrowserBarcodeReader();
        let currentBarcodeInput = null; // لتتبع حقل الإدخال الحالي لباركود المنتج

        // ------------------ الأدوات المساعدة ------------------
        function showStatus(message, type = 'info') {
            statusDiv.innerHTML = `<div class="alert alert-${type}">${message}</div>`;
        }
        
        // ------------------ وظيفة منع زر Enter من إرسال النموذج ------------------
        // يتم إرسال النموذج الكبير (multiDeliveryForm) عند الضغط على Enter في أي حقل
        // سنمنع ذلك ونقوم بدلاً منه بتشغيل دالة البحث إذا كان التركيز على حقل باركود
        function preventFormSubmitOnEnter(e) {
            if (e.key === 'Enter') {
                const activeElement = document.activeElement;
                
                // إذا كان التركيز على حقل باركود (باركود منتج أو رقم سند)
                if (activeElement.classList.contains('barcode-input') || activeElement.id === 'delivery_note_ref') {
                    e.preventDefault(); // منع الإرسال الافتراضي

                    // إذا كان باركود منتج، قم بتشغيل زر "إدخال" المخصص له
                    if (activeElement.classList.contains('barcode-input')) {
                        const productItem = activeElement.closest('.product-item');
                        const enterBtn = productItem.querySelector('.enter-barcode-btn');
                        if (enterBtn) {
                            enterBtn.click();
                        }
                    } 
                    // إذا كان رقم سند، يمكنك هنا إضافة أي إجراء تريد (مثل التركيز على أول حقل باركود)
                    else if (activeElement.id === 'delivery_note_ref') {
                        // التركيز على أول حقل باركود بعد إدخال رقم السند
                        const firstBarcodeInput = document.querySelector('.barcode-input');
                        if (firstBarcodeInput) {
                            firstBarcodeInput.focus();
                        }
                    }
                }
            }
        }
        
        // ربط دالة المنع بالنموذج
        multiDeliveryForm.addEventListener('keypress', preventFormSubmitOnEnter);
        
        // ------------------ وظيفة البحث بالباركود (مكررة للتكامل) ------------------
        async function fetchProduct(barcode, index) {
            const productItem = document.querySelector(`.product-item[data-index="${index}"]`);
            const descField = document.getElementById(`desc-${index}`);
            const idField = productItem.querySelector('.product-id');
            const barcodeInput = document.getElementById(`barcode-${index}`);
            
            // تهيئة الحقول قبل البحث
            descField.value = 'جاري البحث...';
            descField.classList.remove('text-danger', 'text-success');
            idField.value = '';
            
            delete productsData[index];

            try {
                const res = await fetch(SEARCH_URL, {
                    method: 'POST',
                    headers: {'Content-Type': 'application/json'},
                    body: JSON.stringify({ barcode: barcode })
                });
                const j = await res.json();

                if (j.error || !j.id) {
                    descField.value = `❌ ${j.error || 'المنتج غير موجود'}`;
                    descField.classList.add('text-danger');
                    showStatus(`لم يتم العثور على المنتج بالباركود ${barcode}`, 'danger');
                    return;
                }

                if (j.delivery_note_ref && j.delivery_note_ref.trim() !== '') {
                    descField.value = `❌ مسجل مسبقاً (السند: ${j.delivery_note_ref}). التعديل مقتصر على المدير.`;
                    descField.classList.add('text-danger');
                    showStatus(`المنتج ${j.name} مُسجل له سند بالفعل.`, 'warning');
                    return;
                }
                
                const description = `الاسم: ${j.name}\nالمقاس: ${j.size || 'غير محدد'}\nتاريخ الإنتاج: ${j.production_date || 'غير محدد'}\nتاريخ الانتهاء: ${j.expiry_date || 'غير محدد'}`;
                descField.value = description;
                descField.classList.add('text-success');
                idField.value = j.id;
                
                productsData[index] = { id: j.id }; 

                showStatus(`✅ تم تحميل بيانات المنتج ${j.name} (ID: ${j.id})`, 'success');

            } catch (e) {
                descField.value = 'خطأ في الاتصال.';
                descField.classList.add('text-danger');
                showStatus('حدث خطأ في الاتصال: ' + e.message, 'danger');
            }
        }
        
        // ------------------ 5. وظيفة المسح الضوئي لباركود المنتج ------------------
        function handleScanBarcode(targetInput) {
            
            // إيقاف مسح السند إذا كان نشطاً
            if (scanNoteActive) {
                codeReader.reset();
                videoNoteContainer.style.display = 'none';
                scanNoteBtn.innerHTML = '<i class="bi bi-camera-fill"></i>';
                scanNoteActive = false;
            }

            const productItem = targetInput.closest('.product-item');
            if (!productItem) return;
            
            // زر الكاميرا الذي تم النقر عليه
            const currentScanBtn = productItem.querySelector('.scan-barcode-btn');

            // ⚠️ توقف المسح إذا كان نشطاً
            if (scanActive) {
                codeReader.reset();
                videoBarcodeContainer.style.display = 'none';
                currentScanBtn.innerHTML = '<i class="bi bi-camera-fill"></i>'; // إيقاف
                currentScanBtn.setAttribute('data-scanning', 'false');
                scanActive = false;
                currentBarcodeInput = null;
                // إعادة حاوية الفيديو لمكانها الأصلي
                document.body.appendChild(videoBarcodeContainer);
                return;
            }
            
            // 🚀 تفعيل المسح
            
            // 1. نقل حاوية الفيديو أسفل حقل الباركود
            currentBarcodeInput = targetInput;
            const inputGroup = targetInput.closest('.input-group');
            if (inputGroup) {
                inputGroup.parentNode.insertBefore(videoBarcodeContainer, inputGroup.nextSibling);
            }
            
            videoBarcodeContainer.style.display = 'block';
            currentScanBtn.innerHTML = '<i class="bi bi-stop-circle-fill"></i>'; // إظهار أيقونة الإيقاف
            currentScanBtn.setAttribute('data-scanning', 'true');
            scanActive = true;

            codeReader.decodeFromVideoDevice(undefined, videoBarcode, (result, err) => {
                if (result) {
                    currentBarcodeInput.value = result.text.trim();
                    currentBarcodeInput.dispatchEvent(new Event('change')); // لتشغيل البحث
                    
                    // إيقاف المسح بعد القراءة بنجاح
                    codeReader.reset();
                    videoBarcodeContainer.style.display = 'none';
                    currentScanBtn.innerHTML = '<i class="bi bi-camera-fill"></i>';
                    currentScanBtn.setAttribute('data-scanning', 'false');
                    scanActive = false;
                    currentBarcodeInput = null;
                    document.body.appendChild(videoBarcodeContainer); // إرجاع الحاوية للجسم
                }
            }).catch(err => {
                showStatus('فشل الوصول للكاميرا (باركود). تأكد من إعطاء الصلاحية.', 'warning');
                
                // تنظيف الحالة حتى عند الفشل
                codeReader.reset();
                videoBarcodeContainer.style.display = 'none';
                currentScanBtn.innerHTML = '<i class="bi bi-camera-fill"></i>';
                currentScanBtn.setAttribute('data-scanning', 'false');
                scanActive = false;
                currentBarcodeInput = null;
                document.body.appendChild(videoBarcodeContainer);
            });
        }
        
        // ------------------ 6. وظيفة المسح الضوئي لرقم السند ------------------
        function handleScanNote() {
            // إيقاف مسح الباركود إذا كان نشطاً
            if (scanActive) {
                // إيقاف مسح الباركود الحالي
                const activeScanBtn = document.querySelector('.scan-barcode-btn[data-scanning="true"]');
                if (activeScanBtn) {
                     activeScanBtn.innerHTML = '<i class="bi bi-camera-fill"></i>';
                     activeScanBtn.setAttribute('data-scanning', 'false');
                }
                codeReader.reset();
                videoBarcodeContainer.style.display = 'none';
                scanActive = false;
                currentBarcodeInput = null;
                document.body.appendChild(videoBarcodeContainer);
            }

            const noteInput = document.getElementById('delivery_note_ref');

            // تبديل حالة المسح
            if (scanNoteActive) {
                codeReader.reset();
                videoNoteContainer.style.display = 'none';
                scanNoteBtn.innerHTML = '<i class="bi bi-camera-fill"></i>'; // إيقاف
                scanNoteActive = false;
                return;
            }

            // تفعيل المسح
            videoNoteContainer.style.display = 'block';
            scanNoteBtn.innerHTML = '<i class="bi bi-stop-circle-fill"></i>'; // تفعيل
            noteInput.value = ''; 
            scanNoteActive = true;

            codeReader.decodeFromVideoDevice(undefined, videoNote, (result, err) => {
                if (result) {
                    noteInput.value = result.text.trim();
                    
                    // إيقاف المسح بعد القراءة بنجاح
                    codeReader.reset();
                    videoNoteContainer.style.display = 'none';
                    scanNoteBtn.innerHTML = '<i class="bi bi-camera-fill"></i>';
                    scanNoteActive = false;
                    
                    // التركيز على أول حقل باركود بعد مسح السند
                    const firstBarcodeInput = document.querySelector('.barcode-input');
                    if (firstBarcodeInput) {
                        firstBarcodeInput.focus();
                    }
                }
            }).catch(err => {
                showStatus('فشل الوصول للكاميرا (رقم السند). تأكد من إعطاء الصلاحية.', 'warning');
                codeReader.reset();
                videoNoteContainer.style.display = 'none';
                scanNoteBtn.innerHTML = '<i class="bi bi-camera-fill"></i>';
                scanNoteActive = false;
            });
        }
        
        // ------------------ 1. إضافة حقول المنتج (تعديل الزر) ------------------
        function addProductItem(barcodeValue = '') {
            const index = productCounter++;
            
            // 1. إزالة زر الكاميرا وزر الإدخال من جميع الحقول السابقة
            document.querySelectorAll('.scan-barcode-btn').forEach(btn => btn.remove());
            document.querySelectorAll('.enter-barcode-btn').forEach(btn => btn.remove());

            // 2. تحديد أزرار الإدخال والكاميرا الجديدة
            const scanBtnHtml = `
                <button class="btn btn-success text-white camera-btn scan-barcode-btn" type="button" data-index="${index}" title="مسح باركود بالكميرا">
                    <i class="bi bi-camera-fill"></i>
                </button>
            `;
            
            // الزر الجديد للإدخال اليدوي
            const enterBtnHtml = `
                <button class="btn btn-primary enter-barcode-btn" type="button" data-index="${index}" title="إدخال الباركود">
                    <i class="bi bi-arrow-return-left"></i>
                </button>
            `;

            const itemHtml = `
                <div class="product-item" data-index="${index}">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="barcode-${index}" class="form-label">باركود المنتج</label>
                            <div class="input-group">
                                <input type="text" class="form-control barcode-input" id="barcode-${index}" placeholder="أدخل الباركود يدوياً" value="${barcodeValue}" required>
                                ${enterBtnHtml} 
                                ${scanBtnHtml}
                                <button type="button" class="btn btn-danger remove-product-btn" data-index="${index}" title="إزالة المنتج" ${productCounter === 1 ? 'style="display:none;"' : ''}>
                                    <i class="bi bi-trash"></i>
                                </button>
                            </div>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="desc-${index}" class="form-label">مواصفات المنتج (الوصف)</label>
                            <textarea class="form-control product-desc-input disabled-input" id="desc-${index}" rows="3" readonly></textarea>
                            <input type="hidden" class="product-id" name="products[${index}][id]">
                        </div>
                    </div>
                </div>
            `;
            productsContainer.insertAdjacentHTML('beforeend', itemHtml);
            
            const newBarcodeInput = document.getElementById(`barcode-${index}`);
            
            // ربط الحدث بحقل الباركود الجديد (الضغط على زر الإدخال)
            const newEnterBtn = productsContainer.querySelector(`.enter-barcode-btn[data-index="${index}"]`);
            if (newEnterBtn) {
                newEnterBtn.addEventListener('click', () => {
                    if (newBarcodeInput.value.trim()) {
                        fetchProduct(newBarcodeInput.value.trim(), index);
                    }
                });
            }

            // ربط حدث change لبحث الباركود (يستخدم غالباً من الماسح الضوئي)
            newBarcodeInput.addEventListener('change', (e) => {
                if (e.target.value.trim()) {
                    fetchProduct(e.target.value.trim(), index);
                }
            });
            
            // تحديث زر الحذف (ظهور زر الحذف إذا كان هناك أكثر من حقل)
            document.querySelectorAll('.remove-product-btn').forEach(btn => {
                btn.style.display = (productCounter > 1) ? 'block' : 'none';
            });

            // إذا تم إدخال باركود عبر الماسح، قم ببدء البحث مباشرة
            if (barcodeValue) {
                fetchProduct(barcodeValue, index);
            }
        }
        
        // ------------------ 7. وظيفة إزالة منتج ------------------
        function removeProduct(index) {
            const itemToRemove = document.querySelector(`.product-item[data-index="${index}"]`);
            if (itemToRemove) {
                itemToRemove.remove();
                delete productsData[index];
                
                const remainingItems = productsContainer.querySelectorAll('.product-item');
                
                // إذا تم حذف آخر منتج، قم بإضافة منتج جديد
                if (remainingItems.length === 0) {
                    addProductItem();
                } else {
                    // 1. إزالة جميع أزرار الكاميرا والإدخال من الحقول السابقة
                    document.querySelectorAll('.scan-barcode-btn').forEach(btn => btn.remove());
                    document.querySelectorAll('.enter-barcode-btn').forEach(btn => btn.remove());
                    
                    // 2. نقل الزر إلى آخر منتج متبقي
                    const lastItemIndex = remainingItems.length - 1;
                    const lastItem = remainingItems[lastItemIndex];
                    const lastInputGroup = lastItem.querySelector('.input-group');
                    const lastBarcodeInput = lastItem.querySelector('.barcode-input');
                    const lastIndex = lastItem.getAttribute('data-index');
                    
                    const newScanBtnHtml = `
                        <button class="btn btn-success text-white camera-btn scan-barcode-btn" type="button" data-index="${lastIndex}" title="مسح باركود بالكميرا">
                            <i class="bi bi-camera-fill"></i>
                        </button>
                    `;
                    const newEnterBtnHtml = `
                        <button class="btn btn-primary enter-barcode-btn" type="button" data-index="${lastIndex}" title="إدخال الباركود">
                            <i class="bi bi-arrow-return-left"></i>
                        </button>
                    `;
                    
                    if (lastInputGroup && lastBarcodeInput) {
                        // إضافة زر الكاميرا وزر الإدخال بعد حقل الإدخال
                        lastBarcodeInput.insertAdjacentHTML('afterend', newScanBtnHtml);
                        lastBarcodeInput.insertAdjacentHTML('afterend', newEnterBtnHtml);
                        
                        // إعادة ربط الحدث لزر الإدخال الجديد
                        const newEnterBtn = productsContainer.querySelector(`.enter-barcode-btn[data-index="${lastIndex}"]`);
                        if (newEnterBtn) {
                            newEnterBtn.addEventListener('click', () => {
                                if (lastBarcodeInput.value.trim()) {
                                    fetchProduct(lastBarcodeInput.value.trim(), lastIndex);
                                }
                            });
                        }
                    }
                }
                
                // تحديث عرض أزرار الحذف
                document.querySelectorAll('.remove-product-btn').forEach(btn => {
                    btn.style.display = (productsContainer.querySelectorAll('.product-item').length > 1) ? 'block' : 'none';
                });
                
                // إيقاف المسح إذا كان نشطاً وتوقفت الكاميرا
                if (scanActive) {
                    codeReader.reset();
                    videoBarcodeContainer.style.display = 'none';
                    scanActive = false;
                    document.body.appendChild(videoBarcodeContainer);
                }
            }
        }

        // ------------------ 3. وظيفة الحفظ ------------------
        multiDeliveryForm.addEventListener('submit', async e => {
            e.preventDefault();
            
            const ref = document.getElementById('delivery_note_ref').value.trim();
            const date = document.getElementById('delivery_date').value;

            const productsToSave = [];
            
            let formValid = true;

            document.querySelectorAll('.product-item').forEach(item => {
                const idField = item.querySelector('.product-id');
                const barcodeInput = item.querySelector('.barcode-input');
                const index = item.getAttribute('data-index');
                const descField = item.querySelector('.product-desc-input');

                // التحقق من أن الباركود مدخل وله ID صحيح (تم البحث بنجاح)
                if (idField.value && productsData[index] && productsData[index].id === idField.value) {
                    productsToSave.push(idField.value);
                } else if (barcodeInput.value.trim() && !idField.value) {
                    // إذا كان الباركود موجوداً لكن لم يتم التحقق منه بنجاح
                    descField.value = "يرجى إدخال الباركود يدوياً والضغط على زر الإدخال أو المسح";
                    descField.classList.remove('text-success');
                    descField.classList.add('text-danger');
                    formValid = false;
                }
            });

            if (!formValid) {
                showStatus('يرجى التحقق من صحة جميع الباركودات المدخلة والضغط على زر "إدخال" بجوار كل باركود قبل الحفظ.', 'danger');
                return; 
            }

            if (productsToSave.length === 0) {
                 showStatus('لم يتم العثور على أي منتج صالح للحفظ. يرجى مراجعة الباركودات.', 'danger');
                 return;
            }

            showStatus(`جاري حفظ السند رقم ${ref} لعدد ${productsToSave.length} منتجات...`, 'info');
            
            saveBtn.disabled = true;
            document.getElementById('delivery_note_ref').readOnly = true;
            document.getElementById('delivery_date').readOnly = true;
            addProductBtn.disabled = true;

            let successCount = 0;
            let errorCount = 0;
            let lastError = '';

            for (const productId of productsToSave) {
                const data = {
                    id: productId,
                    delivery_note_ref: ref,
                    delivery_date: date
                };
                
                try {
                    const res = await fetch(API_URL, {
                        method: 'POST',
                        headers: { 'Content-Type': 'application/json' },
                        body: JSON.stringify(data) 
                    });
                    const j = await res.json(); 

                    if (j.ok) {
                        successCount++;
                    } else {
                        errorCount++;
                        lastError = j.error || "خطأ غير معروف في الخادم";
                    }
                } catch (e) {
                    errorCount++;
                    lastError = "خطأ في الاتصال بالخادم أو تنسيق الاستجابة (API غير سليم).";
                }
            }
            
            function freezeForm(success = true) {
                document.getElementById('delivery_note_ref').readOnly = true;
                document.getElementById('delivery_date').readOnly = true;
                document.querySelectorAll('.barcode-input').forEach(input => input.readOnly = true);
                
                document.querySelectorAll('.remove-product-btn').forEach(btn => btn.style.display = 'none');
                document.querySelectorAll('.enter-barcode-btn').forEach(btn => btn.style.display = 'none'); // إخفاء زر الإدخال
                addProductBtn.style.display = 'none';
                
                // إخفاء أزرار الكاميرا
                scanNoteBtn.style.display = 'none';
                document.querySelectorAll('.scan-barcode-btn').forEach(btn => btn.style.display = 'none');
                
                // إخفاء حاويات الفيديو
                videoNoteContainer.style.display = 'none';
                videoBarcodeContainer.style.display = 'none';
                
                if (success) {
                    saveBtn.style.display = 'none';
                    newNoteBtn.style.display = 'block';
                }
            }
            
            if (errorCount > 0) {
                const total = productsToSave.length;
                showStatus(`⚠️ تم حفظ ${successCount} منتج بنجاح، وفشل حفظ ${errorCount} منتج. آخر خطأ: ${lastError}`, 'warning');
                freezeForm(false);
            } else {
                showStatus(`🎉 تم حفظ السند رقم ${ref} بنجاح لعدد ${successCount} منتج!`, 'success');
                freezeForm(true);
            }
            
            saveBtn.disabled = false;
        });
        
        // ------------------ 4. وظيفة سند جديد (إعادة التعيين) ------------------
        newNoteBtn.addEventListener('click', () => {
            multiDeliveryForm.reset();
            document.getElementById('delivery_note_ref').readOnly = false;
            document.getElementById('delivery_date').readOnly = true; 
            document.getElementById('delivery_date').value = new Date().toISOString().substring(0, 10);
            
            // إعادة تفعيل الأزرار والحقول
            saveBtn.style.display = 'block';
            newNoteBtn.style.display = 'none';
            addProductBtn.disabled = false;
            addProductBtn.style.display = 'block';
            statusDiv.innerHTML = '';
            
            productsData = {};
            productCounter = 0;
            productsContainer.innerHTML = '';
            addProductItem(); 
            
            // إعادة إظهار أزرار الكاميرا وحقول الإدخال
            scanNoteBtn.style.display = 'flex';
            document.querySelectorAll('.barcode-input').forEach(input => input.readOnly = false);
            document.querySelectorAll('.scan-barcode-btn').forEach(btn => btn.style.display = 'flex'); 
            document.querySelectorAll('.enter-barcode-btn').forEach(btn => btn.style.display = 'flex'); // إعادة زر الإدخال
        });
        
        // ------------------ ربط الأحداث الرئيسية ------------------
        
        // ✅ 1. ربط زر مسح رقم السند
        scanNoteBtn.addEventListener('click', handleScanNote);

        // ✅ 2. ربط زر إضافة منتج
        addProductBtn.addEventListener('click', () => {
            addProductItem();
            document.getElementById(`barcode-${productCounter - 1}`).focus();
        });

        // ✅ 3. تفويض الحدث لزر مسح الباركود وأزرار الحذف
        productsContainer.addEventListener('click', function(e) {
            // مسح الباركود
            const scanBtn = e.target.closest('.scan-barcode-btn');
            if (scanBtn) {
                const targetInput = document.getElementById(`barcode-${scanBtn.getAttribute('data-index')}`);
                handleScanBarcode(targetInput);
                return;
            }
            // إزالة منتج
            const removeBtn = e.target.closest('.remove-product-btn');
            if (removeBtn) {
                const index = removeBtn.getAttribute('data-index');
                removeProduct(index);
            }
        });

        // 💡 وظيفة تهيئة أولية: إضافة حقل منتج عند تحميل الصفحة
        document.addEventListener('DOMContentLoaded', () => {
            // إعادة حاوية الفيديو لباركود المنتج إلى الجسم لتهيئتها
            document.body.appendChild(videoBarcodeContainer);
            
            if (productsContainer.children.length === 0) {
                addProductItem(); 
            }
        });
    </script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>