<?php
// FILE: auth.php (معالج تسجيل الدخول والخروج)
require_once __DIR__ . '/init.php';

if($_SERVER['REQUEST_METHOD'] === 'POST'){
    $u = $_POST['username'] ?? '';
    $p = $_POST['password'] ?? '';
    
    // البحث عن المستخدم
    $stmt = $pdo->prepare('SELECT id,username,password_hash,role FROM users WHERE username = ? LIMIT 1');
    $stmt->execute([$u]);
    $user = $stmt->fetch();
    
    // التحقق من كلمة المرور
    if($user && password_verify($p, $user['password_hash'])){
        // تسجيل الدخول بنجاح
        unset($user['password_hash']);
        $_SESSION['user'] = $user;
        
        // 🚀 منطق التوجيه الجديد بناءً على الدور
        if ($user['role'] === 'super_admin' || $user['role'] === 'admin') {
            // التوجيه إلى لوحة التحكم الإدارية الجديدة (في المجلد الجذري)
            header('Location: /barcode-system/admin_dashboard.php'); 
            exit;
        } elseif ($user['role'] === 'delivery_agent') {
            // التوجيه إلى لوحة تحكم مندوب التسليم (في المجلد الجذري)
            header('Location: /barcode-system/delivery_dashboard.php');
            exit;
        }
        
        // في حال كان الدور غير مصرح به أو مفقود، سنقوم بتسجيل الخروج وإظهار رسالة خطأ
        header('Location: /barcode-system/admin/login.php?error=invalid_role');
        exit;
    }
    
    // فشل تسجيل الدخول: حفظ الخطأ وإعادة التوجيه لصفحة الدخول
    // نستخدم الآن متغير GET (error) بدلاً من SESSION للحصول على رسالة في login.php
    header('Location: /barcode-system/admin/login.php?error=بيانات الدخول غير صحيحة');
    exit;
}

if(isset($_GET['action']) && $_GET['action']==='logout'){
    // تسجيل الخروج
    session_destroy();
    
    // التوجيه إلى صفحة تسجيل الدخول (باستخدام المسار المطلق)
    header('Location: /barcode-system/admin/login.php');
    exit;
}